/*
 * Definitions for communication with agents.
 */
#ifndef _lf_fma_comm_h_
#define _lf_fma_comm_h_

#include "libfma.h"		/* for lf_string_t */

/*
 * Message header to FMA
 */
struct lf_fma_msg_header {
  uint32_t length_32;
  uint32_t msg_type_32;
};

/* types of messages for the agents */
enum {
  LF_FMA_TERMINATE,	/* the FMA is directed to exit */
  LF_FMA_TOPO_MAP,	/* FMS is sending map to FMA */
  LF_FMA_TOPO_LINK_STATE, /* FMS is sending topo map link state to FMA */
  LF_FMA_SPARE_1,
  LF_FMA_SPARE_2,
  LF_FMA_SET_ROUTE,	/* set routes to a node on the fabric */
  LF_FMA_MAP_FABRIC,	/* tells FMA to map entire fabric */
  LF_FMA_SEND_INVALID_ROUTE,	/* FMS is sending map to FMA */
  LF_FMA_SETTINGS,	/* values of settable parameters */
  LF_FMA_PROXY_FMS_TO_FMA,

  LF_FMA_DO_COMMAND,	/* execute an OS command and return results */

  LF_FMA_MSG_COUNT	/* number of message types */
};

union lf_fma_message {
  /* termination message */
  struct lf_fma_terminate {
    lf_string_t reason;		/* why the FMA is shutting down */
  } terminate;

  /* topo map message is defined in lf_topo_map.h */

  /* LF_FMA_SETTINGS */
  struct lf_fma_settings {
    uint32_t verify_interval_32;/* ms after last successful reply to retry */
    uint32_t verify_timeout_32;	/* ms after last failed attempt to retry */
    uint32_t verify_retries_32;	/* number of times to retry before failure */

    uint32_t nic_query_interval_32;	/* ms between NIC status queries */
    uint32_t nic_badcrc_threshold_32;	/* badcrc threshold */

    uint32_t nic_scout_timeout_32;	/* NIC scout timeout */
    uint32_t nic_scout_retries_32;	/* NIC scout retries */
  } settings;

  /* set routes to a node */
  struct lf_fma_set_route {
    uint32_t local_nic;		/* index of NIC */
    uint8_t remote_nic[8];	/* ID of remote NIC */
    uint32_t num_routes_32;	/* number of routes in this message */

    uint8_t route_data[1];	/* packed route data of the form:
				    route_len[0], local_port[0], remote_port[0],
				       route[0][0], route[0][1],...,
				    route_len[1], local_port[1], remote_port[1],
				       route[1][0], route[1][1],...
				 */
  } setroute;


  /* Send to invalid routes message */
  struct lf_fma_send_inv_rt {
    uint32_t ir_seq_no_32;
    uint32_t ir_xbar_index_32;
    uint32_t ir_num_pkts_32;
  } inv_rt;


  /* LF_FMA_MAP_FABRIC - map fabric message has no data */

  /* execute a command on the local node */
  struct lf_fma_do_command {
    uint8_t command[1];		/* NULL-terminated command to execute */
  } docmd;

  /* Message from FMS destined for a proxy-served FMA */
  struct lf_proxy_fms_to_fma {
    struct lf_proxy_fms_to_fma_hdr {

      uint8_t route[MYRI_MAX_ROUTE_LEN];
      uint8_t route_len_8;

      uint8_t nic_index_8;
      uint8_t port_8;

      uint8_t pad[5];		/* make this divisible by 8 */
    } h;

    /* embedded type and length */
    struct lf_fma_msg_header eh;

    /* embedded data starts here */
  } proxy_fms_to_fma;
};

#endif /* _lf_fma_comm_h_ */
